#!/usr/bin/env python
#
# xkmap_ui.py   --  Simple GUI for xorg keymap configuring and setting

# (c) Copyright 2009-2010 Michael Towers (larch42 at googlemail dot com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#-------------------------------------------------------------------
# 2010.08.08

import sys, os
_thisdir = os.path.dirname(os.path.realpath(__file__))
sys.path.append(os.path.dirname(_thisdir))

from liblarch.suim import Suim

import __builtin__

from xkmap_base import Xkmap
from xkmap_ui import XkmapGui

# Supply backend (file-system) services to the gui
_running = False
def fss(func, *args):
    if func:
        if _running and (func[0] != '_'):
            ui.busy(True)
        # (Repeated setting or unsetting of the busy state is just ignored)
        result = getattr(app, 'fss_' + func)(*args)
        # When the function is not finished, it returns None, otherwise (ok, val)
    else:
        result = True
    if _running and result != None:
        ui.busy(False)
    return result

__builtin__.fss = fss

def ui_signal(sig, *args):
    xkmgui.sigin(sig, *args)

__builtin__.ui_signal = ui_signal


if __name__ == "__main__":
    app = Xkmap()
    __builtin__.ui = Suim('xkmap', ['xkmap'])
    xkmgui = XkmapGui()
    _running = True
    xkmgui.start()
