#!/usr/bin/env python
# Configuration file for xkmap
# 2010.08.03

# Set this for your system (probably one of these is OK)
base_lst = '/usr/share/X11/xkb/rules/base.lst'
#base_lst = '/etc/X11/xkb/rules/base.lst'
#base_lst = '/usr/lib/X11/xkb/rules/base.lst'

configdir = '/etc/X11/xorg.conf.d'
configfile = '20-xkmap.conf'

# The xmodmap settings for the all users
xmodmapg = '/etc/X11/xinit/xmodmap.in'

# The keymap settings file for the current user (relative to home directory)
configuser = '.config/xkmap/keymap'

# The xmodmap settings for the current user (relative to home directory)
xmodmapu = '.config/xkmap/xmodmap.in'

DEFAULTMODEL = 'pc101'
DEFAULTLAYOUT = 'us'
STANDARDVARIANT = ('-', 'Standard')

template_xorg = """# %s/%s
# This file was generated by xkmap to set the keyboard mapping
# It may be overriden by configuration files loaded later in xorg's
# start sequence.
#
# Edit this file with caution - be aware that it may well be overwritten
# by future use of xkmap.
#
# See the xorg.conf manual page for further configuration details.
#
Section "InputClass"
    Identifier          "xkmap keyboard settings"
    MatchIsKeyboard     "yes"
#MODEL:___M___
#***M***
#LAYOUT:___L___
#***L***
#VARIANT:___V___
#***V***
EndSection
""" % (configdir, configfile)

modelLine = '    Option              "XkbModel"      "%s"'
layoutLine = '    Option              "XkbLayout"     "%s"'
variantLine = '    Option              "XkbVariant"    "%s"'

template_user = """#!/bin/sh
# ~/%s
# This file was generated by xkmap to set the keyboard mapping for a single
# user, it will override the global settings.
# In order for it to be effective it must be run during session start-up,
# for example from ~/.xinitrc or using some autorun feature of the session
# manager - the optimal approach depends on the way Xorg is started.
#
#MODEL:___M___
#LAYOUT:___L___
#VARIANT:___V___
#X# insert setxkbmap command here
""" % configuser

modelopt = ' -model %s'
layoutopt = ' -layout %s'
variantopt = ' -variant %s'

