#!/usr/bin/env python
#
# xkmap_ui.py   --  Simple GUI for xorg keymap configuring and setting

# (c) Copyright 2009-2010 Michael Towers (larch42 at googlemail dot com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#-------------------------------------------------------------------
# 2010.08.07

class XkmapGui:
    def __init__(self):
        ui.widgetlist(fss('fetch_layout', 'xkmap-widget.uim'))
        ui.widgetlist(fss('fetch_layout', 'xkmap.uim'))
        ui.connect('$$$uiquit$$$', ui.quit)


    def sigin(self, signal, *args):
        ui.idle_add(getattr(self, 'sig_' + signal), *args)


    def start(self):
        self.models = fss('models')
        self.layouts = fss('layouts')
        startdata = fss('startdata')
        im = self.seekindex(self.models, startdata[0])
        il = self.seekindex(self.layouts, startdata[1])
        self.v0 = startdata[2]

        # Populate choice widgets
        ui.command('xkmap:model.set',
                ['%-16s%s' % (m, c[:30]) for m, c in self.models], im)
        ui.command('xkmap:layout.set',
                ['%-16s%s' % tuple(i) for i in self.layouts], il)
        self.newModel(im, False)
        self.newLayout(il)

        ui.connectlist(
                ('xkmap:settemp*clicked', self._settemp),
                ('xkmap:setuser*clicked', self._setuser),
                ('xkmap:clearuser*clicked', self._clearuser),
                ('xkmap:setglobal*clicked', self._setglobal),
                ('xkmap:model*changed', self.newModel),
                ('xkmap:layout*changed', self.newLayout),
                ('xkmap:variant*changed', self.newVariant),
                ("xkmap:docs*clicked", self._showdocs),
            )

        ui.command('xkmap:docview.html', fss('about'))
        self._showdocs(init=True)
        ui.command('xkmap:clearuser.enable', fss('uenabled'))

        ui.command('xkmap.pack')
        ui.command('xkmap.show')
        ui.run()


    def data(self, key):
        return ui.command('xkmap_data.get', key)


    def _settemp(self, cmd='setnow'):
        ok, mess = fss(cmd, self.model, self.layout, self.variant)
        if ok:
            ui.command('infoDialog', mess)
        return ok


    def _setuser(self):
        if self._settemp('setuser'):
            ui.command('xkmap:clearuser.enable', True)


    def _setglobal(self):
        fss('setglobal', self.model, self.layout, self.variant)


    def sig_get_password(self, message):
        """This is a callback, triggered by signal 'get_password'
        to ask the user to input the password.
        """
        fss('sendpassword', *ui.command('textLineDialog', message,
                "xkmap: pw", "", True))


    def sig_showcompleted(self, ok, mess):
        """This is a callback, triggered by signal 'showcompleted'
        to display an info dialog.
        """
        ui.command('infoDialog' if ok else 'warningDialog', mess)
        fss(None)       # Tell fss that the command has terminated


    def _clearuser(self):
        ok, res = fss('clearuser')
        if ok:
            ui.command('xkmap:clearuser.enable', False)
            ui.command('infoDialog', res)
        else:
            ui.command('warningDialog', res)


    def _showdocs(self, init=False):
        self.helpstate = False if init else not self.helpstate
        ui.command('xkmap:stack.set', 1 if self.helpstate else 0)
        ui.command('xkmap:docs.text', self.data('hidetext')
                if self.helpstate else self.data('showtext'))
        ui.command('xkmap:docs.tt', self.data('hidett')
                if self.helpstate else self.data('showtt'))


    def newModel(self, index, show=True):
        self.model, tt = self.models[index]
        ui.command('xkmap:model.tt', tt)
        if show:
            self.showCommand()


    def newLayout(self, index):
        self.layout = self.layouts[index][0]
        self.variants = fss('variantlist', self.layout)
        vi, i = 0, 0
        items = []
        for item0, item1 in self.variants:
            if len(item1) > 30:
                item1 = item1[:30]
            items.append("%-16s%s" % (item0, item1[:30]))
            if item0 == self.v0:
                vi = i
                tt = item1
            i += 1
        ui.command('xkmap:variant.set', items, vi)
        self.newVariant(vi)


    def newVariant(self, index):
        self.variant, tt = self.variants[index]
        ui.command('xkmap:variant.tt', tt)
        self.showCommand()


    def showCommand(self):
        ui.command('xkmap:command.text', fss('command',
                self.model, self.layout, self.variant))


    def seekindex(self, tulist, element):
        """Return the index of the tuple in tulist whose first item
        is element.
        """
        i = 0
        for tu in tulist:
            if tu[0] == element:
                return i
            i += 1
        assert False, "Element not in list"

